// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockInitialization.model.RatedArticle', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'articleId', type: 'int' },
        { name: 'detailsId', type: 'int' },
        { name: 'articleName', type: 'string' },
        { name: 'additionalText', type: 'string' },
        { name: 'supplier', type: 'string' },
        { name: 'orderNumber', type: 'string' },
        { name: 'instock', type: 'int' },
        { name: 'openOrders', type: 'int' },
        { name: 'actualStock', type: 'int' },
        { name: 'purchasePrice', type: 'decimal' },
    ],
    proxy: {
        type: 'ajax',
        api: {
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockInitialization/updateArticle'),
        },
    },

    isSane: function () {
        return (this.get('actualStock') >= 0);
    },

});
