// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockInitialization.view.Description', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_stock_initialization-description',
    cls: 'viison_pickware_erp_stock_initialization-description viison-common--sidebar has--header-size-large',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_initialization/main',

    border: false,
    collapsible: true,
    collapsed: false,
    scrollable: true,
    layout: 'fit',

    initComponent: function () {
        this.title = this.getViisonSnippet('description/title');
        this.items = [{
            xtype: 'component',
            autoEl: {
                tag: 'iframe',
                src: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockInitialization/getDescriptionHtml'),
            },
        }];
        this.callParent(arguments);
    },

});
