// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockInitialization.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_stock_initialization-main',
    cls: 'viison_pickware_erp_stock_initialization-main has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_initialization/main',

    height: '90%',
    layout: 'border',
    width: '95%',

    listeners: {
        afterrender: function () {
            // Apply max size constraints
            if (this.getWidth() > 1300) {
                this.setWidth(1300);
            }
            if (this.getHeight() > 700) {
                this.setHeight(700);
            }
        },
    },

    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.store.load();

        this.items = [{
            xtype: 'viison_pickware_erp_stock_initialization-description',
            store: this.store,
            region: 'west',
            width: 340,
        }, {
            xtype: 'viison_pickware_erp_stock_initialization-list',
            store: this.store,
            region: 'center',
            flex: 2,
        }];

        this.callParent(arguments);
    },

});
