// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.controller.BinLocationList', {

    extend: 'Shopware.apps.ViisonPickwareERPArticleBinLocationList.controller.List',

    listSelectorPrefix: 'viison_pickware_erp_stock_overview-main',

    /**
     * @Override
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {number|null}
     */
    getArticleDetailId: function (listPanel) {
        return listPanel.article.get('id');
    },

    /**
     * @Override
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {number|null}
     */
    getDefaultPurchasePrice: function (listPanel) {
        return listPanel.article.get('purchasePrice');
    },

    /**
     * @Override
     *
     * Creates a callback, which reloads the warehouse field set data, updates the stock field set as well as the
     * purchase price field using the related article detail.
     *
     * @returns {function}
     */
    createEditWarehouseStockCallback: function () {
        return function () {
            this.getController('Main').reloadStockList(true);
        }.bind(this);
    },

});
