// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.model.Article', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'articleId', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'supplier', type: 'string' },
        { name: 'articleName', type: 'string' },
        { name: 'open', type: 'int' },
        { name: 'shipped', type: 'int' },
        { name: 'not_sent', type: 'int' },
        { name: 'instock', type: 'int' },
        { name: 'salesWithinPlanningInterval', type: 'int' },
        { name: 'stock', type: 'int' },
        { name: 'minimumStock', type: 'int' },
        { name: 'targetStock', type: 'int' },
        { name: 'quantity', type: 'int' },
        { name: 'purchasePrice', type: 'float' },
    ],

    proxy: {
        type: 'ajax',
        api: {
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockOverview/updateArticle'),
        },
        writer: {
            // Ensures the stock won't be updated every time
            writeAllFields: false,
        },
    },

    isValidStock: function () {
        return (this.get('not_sent') === this.get('open'))
            && this.get('shipped') >= 0
            && this.get('open') >= 0
            && this.get('not_sent') >= 0
            && this.get('stock') >= 0;
    },

});
