// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.model.Order', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'orderTime', type: 'date' },
        { name: 'status', type: 'string' },
        { name: 'quantity', type: 'int' },
        { name: 'shipped', type: 'int' },
        { name: 'picked', type: 'int' },
    ],
    proxy: {
        type: 'ajax',
        api: {
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockOverview/updateArticle'),
        },
        writer: {
            // Ensures the stock won't be updated every time
            writeAllFields: false,
        },
    },

});
