// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.store.Stock', {

    extend: 'Ext.data.Store',
    storeId: 'viison_pickware_erp_stock_overview-stockStore',
    autoLoad: false,
    remoteFilter: false,
    remoteSort: true,
    model: 'Shopware.apps.ViisonPickwareERPStockOverview.model.Article',
    pageSize: 100,
    sorters: [{
        direction: 'ASC',
        property: 'ordernumber',
    }],
    proxy: {
        type: 'ajax',
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockOverview/getArticles'),
        },
        reader: {
            type: 'json',
            root: 'data',
        },
    },

});
