// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.ux.chart.Legend', {

    override: 'Ext.chart.Legend',

    updatePosition: function () {
        if (typeof this.isViisonPositionTopRight !== 'undefined' && this.position === 'right') {
            var legendWidth = this.width || 0;

            this.position = 'float';
            this.origX = Math.floor(this.chart.surface.width - legendWidth) - this.chart.insetPadding;
            this.origY = 0;
        }

        this.callParent();

        // Reset initial position value
        this.position = 'right';
    },

});
