// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.ux.chart.LegendItem', {

    override: 'Ext.chart.LegendItem',

    createLegend: function (config) {
        if (typeof config.series.viisonLegendMarkerType !== 'undefined') {
            switch (config.series.viisonLegendMarkerType) {
                case 'rect':
                    config.series.type = 'area';
                    break;
                case 'line':
                    config.series.type = 'line';
                    break;
                default:
            }
        }

        this.callParent([config]);
    },

});
