// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Ext.chart.theme.ViisonPickwareERP', {

    extend: 'Ext.chart.theme.Base',

    constructor: function (config) {
        var baseColor = '#555';
        var baseFont = '9px Arial, Helvetica, sans-serif';

        this.callParent([Ext.apply({
            axis: {
                fill: baseColor,
                stroke: baseColor,
                'stroke-width': 1,
            },
            axisLabelTop: {
                fill: baseColor,
                font: baseFont,
            },
            axisLabelLeft: {
                fill: baseColor,
                font: baseFont,
            },
            axisLabelRight: {
                fill: baseColor,
                font: baseFont,
            },
            axisLabelBottom: {
                fill: baseColor,
                font: baseFont,
            },
            axisTitleTop: {
                fill: baseColor,
                font: baseFont,
            },
            axisTitleLeft: {
                fill: baseColor,
                font: baseFont,
            },
            axisTitleRight: {
                fill: baseColor,
                font: baseFont,
            },
            axisTitleBottom: {
                fill: baseColor,
                font: baseFont,
            },
            series: {
                'stroke-width': 1,
            },
            seriesLabel: {
                font: '12px Arial',
                fill: '#333',
            },
            marker: {
                stroke: '#555',
                fill: '#000',
                radius: 3,
                size: 3,
            },
            colors: [
                '#798D8D',
                '#00B35C',
                '#90D5F2',
                '#798D8D',
            ],
        }, config)]);
    },
});
