// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.view.ArticleBinLocationList', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_stock_overview-article-bin-location-list',
    cls: 'viison_pickware_erp_stock_overview-article-bin-location-list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_overview/bin_location_list',

    layout: 'fit',
    border: 0,
    style: {
        borderRight: '1px solid #a4b5c0',
    },
    bodyStyle: {
        borderTop: 'none',
    },

    collapsible: true,
    collapsed: false,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('header/title/initial');
        this.items = [{
            xtype: 'box',
            itemId: 'infoPanel',
            cls: 'is--info-panel',
            autoEl: {
                tag: 'div',
                html: Ext.String.format(
                    '<span><strong>[0]</strong>[1]</span>',
                    this.getViisonSnippet('info/no_selection/title'),
                    this.getViisonSnippet('info/no_selection/body')
                ),
            },
        }, {
            xtype: 'viison_pickware_erp_article_bin_location_list-list',
            itemId: 'binLocationList',
            hasMultiRowHeader: true,
            border: 0,
            style: {
                border: 'none',
            },
            bodyStyle: {
                padding: '0',
            },
            hidden: true,
        }];

        this.callParent(arguments);
    },

    /**
     * @param {Shopware.apps.ViisonPickwareERPStockOverview.model.Article} article
     */
    setArticle: function (article) {
        var binLocationList = this.down('#binLocationList');

        if (binLocationList.isHidden()) {
            this.showBinLocationList();
        }

        binLocationList.article = article;
        binLocationList.getStore().clearFilter(true);
        binLocationList.getStore().filter('binLocationMapping.articleDetailId', article.get('id'));

        this.setTitle(Ext.String.format(
            this.getViisonSnippet('header/title/article/prefix') + ' <strong>[0] ([1])</strong>',
            article.get('articleName'),
            article.get('orderNumber')
        ));
    },

    showBinLocationList: function () {
        this.down('#infoPanel').hide();
        this.down('#binLocationList').show();
        this.doLayout();
    },

    showInfoPanel: function () {
        this.setTitle(this.getViisonSnippet('header/title/initial'));

        this.down('#binLocationList').hide();
        this.down('#infoPanel').show();
        this.doLayout();
    },

});
