// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_stock_overview-main',
    cls: 'viison_pickware_erp_stock_overview-main has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_overview/main',

    height: '90%',
    layout: 'border',
    width: '95%',

    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.store.load();

        this.items = [{
            xtype: 'viison_pickware_erp_stock_overview-planning_interval',
            region: 'north',
            store: this.store,
        }, {
            xtype: 'container',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            region: 'center',
            flex: 4,
            items: [
                {
                    xtype: 'viison_pickware_erp_stock_overview-list',
                    store: this.store,
                    flex: 3,
                },
                {
                    xtype: 'viison_pickware_erp_stock_overview-article-bin-location-list',
                    flex: 2,
                },
            ],
        }, {
            xtype: 'viison_pickware_erp_stock_overview-order-main',
            store: this.orderStore,
            stockStore: this.store,
            salesStore: this.salesStore,
            region: 'east',
            flex: 3,
        }];

        this.callParent(arguments);
    },

});
