// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.view.order.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_stock_overview-order-list',
    cls: 'viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_overview/main',
    viisonConfigNamespace: 'ViisonPickwareERPStockOverview',

    style: 'border-left:none;border-top:none;border-right:none;',

    /**
     * @Override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('orderlist/empty_text');
        this.columns = [{
            header: this.getViisonSnippet('list/column/orderNumber'),
            sortable: false,
            dataIndex: 'orderNumber',
            width: 80,
        }, {
            header: this.getViisonSnippet('list/column/quantity'),
            sortable: false,
            dataIndex: 'quantity',
            width: 60,
        }];

        if (this.getViisonConfig('isViisonPickwareMobileInstalled')) {
            this.columns.push({
                header: this.getViisonSnippet('list/column/picked'),
                sortable: false,
                dataIndex: 'picked',
                width: 70,
            });
        }

        this.columns = this.columns.concat([
            {
                header: this.getViisonSnippet('list/column/shipped'),
                sortable: false,
                dataIndex: 'shipped',
                width: 70,
            }, {
                header: this.getViisonSnippet('list/column/status'),
                sortable: false,
                dataIndex: 'status',
                flex: 1,
                renderer: ViisonStatusTranslator.translateOrderStatus,
            }, {
                header: this.getViisonSnippet('list/column/orderTime'),
                sortable: false,
                dataIndex: 'orderTime',
                flex: 1,
                renderer: Ext.util.Format.dateRenderer('d.m.Y H:i'),
            }, {
                xtype: 'actioncolumn',
                width: 25,
                items: [{
                    iconCls: 'sprite-sticky-notes-pin',
                    action: 'openOrder',
                    tooltip: this.getViisonSnippet('list/column/action/open_order/tooltip'),
                    scope: this,
                    handler: function (view, rowIndex) {
                        this.fireEvent('openOrder', view.getStore().getAt(rowIndex));
                    },
                }],
            },
        ]);

        this.dockedItems = [
            this.getPagingbar(),
        ];

        this.callParent(arguments);
    },

    /**
     * Creates and returns a new paging toolbar and adds a page size selection to it.
     *
     * @return Shopware.apps.ViisonCommonPaginationToolbar The created page toolbar.
     */
    getPagingbar: function () {
        return {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        };
    },

});
