// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.view.order.Main', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_stock_overview-order-main',
    cls: 'viison_pickware_erp_stock_overview-order-main',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_overview/main',

    layout: 'border',
    collapsible: true,
    collapsed: false,
    disabled: true,
    border: 0,

    initComponent: function () {
        this.title = this.getViisonSnippet('window/orderpanel_title');
        this.items = [
            {
                xtype: 'container',
                region: 'north',
                itemId: 'salesChartContainer',
                padding: '30 30 30 30',
                style: 'background-color:white;',
                layout: {
                    type: 'vbox',
                    align: 'stretch',
                },
                height: 300,
                items: [
                    {
                        xtype: 'box',
                        height: 30,
                        autoEl: {
                            tag: 'div',
                            cls: 'viison-common--chart--title',
                            html: this.getViisonSnippet('chart/title/one_year_overview'),
                        },
                    }, {
                        xtype: 'viison_pickware_erp_stock_overview-sales_chart',
                        itemId: 'salesChart',
                        store: this.salesStore,
                        flex: 1,
                    },
                ],
            }, {
                xtype: 'box',
                itemId: 'stats',
                region: 'north',
                autoEl: {
                    tag: 'div',
                    cls: 'viison_pickware_erp_stock_overview-order-main--stats',
                    html: '',
                },
                hidden: true,
            },
            {
                xtype: 'viison_pickware_erp_stock_overview-order-list',
                store: this.store,
                region: 'center',
            },
        ];

        this.callParent(arguments);
    },

    getSalesChart: function () {
        return this.down('#salesChart');
    },

    getSalesChartContainer: function () {
        return this.down('#salesChartContainer');
    },

    showStats: function () {
        this.down('#stats').show();
    },

    hideStats: function () {
        this.down('#stats').hide();
    },

    updateStats: function (quantity, expectedQuantity) {
        this.down('#stats').el.dom.innerHTML = this.getStatsTemplate().apply({
            quantity: quantity,
            expectedQuantity: expectedQuantity,
        });
    },

    getStatsTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--intro-text">',
                    this.getViisonSnippet('orders/description/message'),
                '</div>',
                '<div class="is--stats-container">',
                    '<label>',
                        this.getViisonSnippet('orders/description/current_quantity'),
                    '</label>',
                    '<span>{quantity}</span>',
                '</div>',
                '<div class="is--stats-container">',
                    '<label>',
                        this.getViisonSnippet('orders/description/expected_quantity'),
                    '</label>',
                    '<span>{expectedQuantity}</span>',
                    '<em>',
                        this.getViisonSnippet('orders/description/expected_quantity_addon_info'),
                    '</em>',
                '</div>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
