// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockOverview.view.PlanningInterval', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_stock_overview-planning_interval',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_overview/main',

    style: { backgroundColor: '#f0f2f4', borderBottom: '1px solid #A4B5C0 !important' },
    layout: 'vbox',
    padding: 6,
    height: 55,
    border: false,

    initComponent: function () {
        this.daysSelectionStore = Ext.create('Ext.data.Store', {
            fields: ['value', 'title'],
            data: this.createIntervalOptions(),
        });

        this.items = [
            {
                xtype: 'form',
                border: false,
                layout: 'hbox',
                padding: '6 10 0 10',
                items: [
                    {
                        xtype: 'label',
                        baseCls: 'x-form-item-label',
                        style: 'font-size:120%;opacity:0.5;font-weight:normal;',
                        html: this.getViisonSnippet('label/planning/title'),
                        margin: '3 0 0 0',
                    }, {
                        xtype: 'datefield',
                        itemId: 'fromDate',
                        margin: '0 0 0 18',
                        fieldLabel: this.getViisonSnippet('label/planning/from'),
                        labelWidth: 'auto',
                        labelStyle: 'margin-right:10px;padding-top:4px;',
                        value: this.store.getProxy().extraParams.planningFrom,
                        listeners: {
                            change: function () {
                                this.down('#toDate').setValue(this.calculateToDate());
                            },
                            scope: this,
                        },
                    }, {
                        xtype: 'combobox',
                        itemId: 'intervalInDays',
                        margin: '0 0 0 15',
                        fieldLabel: this.getViisonSnippet('label/planning/interval'),
                        labelWidth: 'auto',
                        labelStyle: 'margin-right:10px;padding-top:4px;',
                        store: this.daysSelectionStore,
                        queryMode: 'local',
                        displayField: 'title',
                        valueField: 'value',
                        value: this.daysSelectionStore.getAt(3).get('value'),
                        forceSelection: true,
                        listeners: {
                            change: function () {
                                this.down('#toDate').setValue(this.calculateToDate());
                            },
                            scope: this,
                        },
                    }, {
                        xtype: 'datefield',
                        itemId: 'toDate',
                        cls: 'viison-common--datefield',
                        margin: '0 0 0 15',
                        fieldLabel: this.getViisonSnippet('label/planning/to'),
                        labelWidth: 'auto',
                        labelStyle: 'margin-right:10px;padding-top:5px;',
                        disabled: true,
                        disabledCls: 'is--disabled',
                        value: this.store.getProxy().extraParams.planningFrom,
                    }, {
                        xtype: 'button',
                        text: this.getViisonSnippet('label/planning/confirm'),
                        cls: 'primary',
                        margin: '1 0 0 20',
                        padding: '1 10 1 10',
                        handler: function () {
                            this.fireEvent('planningRange', {
                                from: this.down('#fromDate').getValue(),
                                to: this.calculateToDate(),
                            });
                        },
                        scope: this,
                    },
                ],
            },
        ];

        this.callParent(arguments);
    },

    /**
     * @return {Object[]}
     */
    createIntervalOptions: function () {
        // 1-3 weeks
        var intervalOptions = Ext.Array.map(
            [1, 2, 3],
            function (weeks) {
                return {
                    value: weeks * 7,
                    title: weeks + ' ' + this.getViisonSnippet('label/planning/time/week'),
                };
            },
            this
        );

        // 1 month
        intervalOptions.push({
            value: 30,
            title: 1 + ' ' + this.getViisonSnippet('label/planning/time/month') + ' (30 ' + this.getViisonSnippet('label/planning/time/days') + ')',
        });

        // 2-12 months
        intervalOptions = intervalOptions.concat(Ext.Array.map(
            [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
            function (months) {
                return {
                    value: months * 30,
                    title: months + ' ' + this.getViisonSnippet('label/planning/time/months') + ' (' + (months * 30) + ' ' + this.getViisonSnippet('label/planning/time/days') + ')',
                };
            },
            this
        ));

        return intervalOptions;
    },

    calculateToDate: function () {
        var fromDate = this.down('#fromDate').getValue();
        var intervalInDays = this.down('#intervalInDays').getValue();

        return Ext.Date.add(fromDate, Ext.Date.DAY, intervalInDays);
    },

});
