// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.base.LargeMessageBox', {
    extend: 'Ext.window.MessageBox',

    constructor: function () {
        this.callParent(arguments);

        this.maxWidth = 750;
    },

    // Copy shopware's UI changes
    afterRender: function () {
        var me = this;
        var toolbar = me.dockedItems.getAt(1);
        toolbar.addCls('shopware-toolbar');
        toolbar.setUI('shopware-ui');

        Ext.each(me.msgButtons, function (button) {
            if (button.itemId === 'ok' || button.itemId === 'yes') {
                button.addCls('primary');
            } else {
                button.addCls('secondary');
            }
        });

        me.callOverridden(arguments);
    },

    reconfigure: function () {
        var me = this;

        me.msg.allowHtml = true;
        me.callParent(arguments);
    },
});
