// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.base.StockTakePanel', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_stock_take_export-base-stock_take_panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_take_export/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },
    border: false,
    style: {
        backgroundColor: '#f0f2f4',
    },

    filterPanel: null,
    gridPanel: null,

    /**
     * @Override
     */
    initComponent: function () {
        var buttonPanel = Ext.create('Ext.form.Panel', {
            region: 'south',
            padding: 15,
            border: false,
            style: {
                borderTop: '1px solid #A4B5C0 !important',
            },
            layout: {
                type: 'hbox',
                align: 'stretch',
            },
            items: this.getBottomButtons(),
        });

        this.items = [
            this.filterPanel,
            this.gridPanel,
            buttonPanel,
        ];

        this.callParent(arguments);
    },

    /**
     * Returns a list of all buttons of this panel.
     *
     * @returns []
     */
    getBottomButtons: function () {
        this.exportButton = Ext.create('Ext.button.Button', {
            xtype: 'button',
            text: this.getViisonSnippet('button/export/text'),
            cls: 'primary',
            handler: function () {
                this.fireEvent('export', this);
            },
            scope: this,
        });

        return [
            {
                xtype: 'tbspacer',
                flex: 1,
            },
            this.exportButton,
        ];
    },
});
