// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.complete.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_stock_take_export-complete-list',
    cls: 'viison-common--grid has--vertical-lines has--no-borders',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_take_export/main',

    flex: 1,

    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.store = Ext.create('Shopware.apps.ViisonPickwareERPStockTakeExport.store.StockTake');
        this.store.on('load', function () {
            this.fireEvent('updateButtons', this.up('panel'));
        }, this);
        this.columns = this.getColumns();
        this.dockedItems = [
            this.createPagingToolbar(),
        ];

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    getColumns: function () {
        return [
            {
                dataIndex: 'articleNumber',
                header: this.getViisonSnippet('grid/column/number'),
                flex: 1,
            }, {
                dataIndex: 'articleName',
                header: this.getViisonSnippet('grid/column/name'),
                flex: 2,
            }, {
                dataIndex: 'oldStock',
                header: this.getViisonSnippet('grid/column/oldInstock'),
                align: 'right',
                flex: 1,
            }, {
                dataIndex: 'newStock',
                header: this.getViisonSnippet('grid/column/newInstock'),
                align: 'right',
                flex: 1,
            }, {
                dataIndex: 'changeAmount',
                header: this.getViisonSnippet('grid/column/changeAmount'),
                align: 'right',
                flex: 1,
            }, {
                dataIndex: 'purchasePrice',
                header: ViisonPickwarePurchasePriceHelper.purchasePriceLabel(),
                tooltip: this.getViisonSnippet('grid/column/purchasePriceToolTip'),
                sortable: false,
                align: 'right',
                flex: 1,
                renderer: ViisonCurrencyFormatter.renderer,
            }, {
                dataIndex: 'taxRate',
                header: this.getViisonSnippet('grid/column/tax'),
                align: 'right',
                flex: 1,
                renderer: function (value) {
                    return value + '%';
                },
            }, {
                dataIndex: 'changeValueNet',
                header: this.getViisonSnippet('grid/column/changeValueNet'),
                sortable: false,
                hidden: true,
                align: 'right',
                flex: 1,
                renderer: ViisonCurrencyFormatter.renderer,
            }, {
                dataIndex: 'changeValueGross',
                header: this.getViisonSnippet('grid/column/changeValueGross'),
                sortable: false,
                hidden: true,
                align: 'right',
                flex: 1,
                renderer: ViisonCurrencyFormatter.renderer,
            }, {
                dataIndex: 'username',
                header: this.getViisonSnippet('grid/column/user'),
                flex: 1,
            }, {
                xtype: 'datecolumn',
                dataIndex: 'stockCreationDate',
                header: this.getViisonSnippet('grid/column/stockCreated'),
                format: 'd.m.Y H:i:s',
                flex: 1,
            }, {
                dataIndex: 'comment',
                header: this.getViisonSnippet('grid/column/comment'),
                sortable: false,
                flex: 2,
            }, {
                xtype: 'actioncolumn',
                width: 30,
                align: 'center',
                items: [
                    {
                        iconCls: 'sprite-inbox',
                        tooltip: this.getViisonSnippet('tooltip/openArticle'),
                        scope: this,
                        handler: function (view, rowIndex) {
                            this.fireEvent('openArticle', view.getStore().getAt(rowIndex).get('articleId'));
                        },
                    },
                ],
            },
        ];
    },

    /**
     * Creates and returns a new paging toolbar and adds a page size selection to it.
     *
     * @return Shopware.apps.ViisonCommonPaginationToolbar
     */
    createPagingToolbar: function () {
        return {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        };
    },

});
