// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_stock_take_export-main',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_take_export/main',

    layout: 'border',
    width: '90%',
    height: '80%',
    maximizable: true,
    minimizable: true,
    border: false,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');

        this.items = [
            {
                xtype: 'tabpanel',
                border: false,
                region: 'center',
                height: '100%',
                items: [
                    {
                        xtype: 'viison_pickware_erp_stock_take_export-complete-main',
                    }, {
                        xtype: 'viison_pickware_erp_stock_take_export-pending-main',
                    },
                ],
                listeners: {
                    scope: this,
                    tabchange: function (tabPanel, newTab) {
                        // You can always switch to the pending panel
                        if (newTab.xtype === 'viison_pickware_erp_stock_take_export-pending-main') {
                            return;
                        }

                        // Ignore the tab change to the complete panel from the user and let the controller handle it
                        tabPanel.suspendEvents();
                        tabPanel.setActiveTab(1);
                        tabPanel.resumeEvents();
                        this.fireEvent('tabChange', this);
                    },
                },
            },
        ];

        this.callParent(arguments);
    },

});
