// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.pending.Filter', {

    extend: 'Shopware.apps.ViisonPickwareERPStockTakeExport.view.base.Filter',
    alias: 'widget.viison_pickware_erp_stock_take_export-pending-filter',

    /**
     * @Override
     */
    createFilterForm: function () {
        var filterForm = this.callParent();

        // Remove: user combobox and do-date fields and labels
        var keptItems = filterForm.items.slice(0, 6);
        var searchBar = filterForm.items.slice(1).slice(-2);

        // Update the snippet of the from-date field
        keptItems[3].text = this.getViisonSnippet('filter/pendingDateFrom/label') + ':';

        filterForm.items = keptItems.concat(searchBar);

        return filterForm;
    },
});
