// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.pending.Main', {

    extend: 'Shopware.apps.ViisonPickwareERPStockTakeExport.view.base.StockTakePanel',
    alias: 'widget.viison_pickware_erp_stock_take_export-pending-main',

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('panel/pending/title');
        this.filterPanel = Ext.create('Shopware.apps.ViisonPickwareERPStockTakeExport.view.pending.Filter');
        this.gridPanel = Ext.create('Shopware.apps.ViisonPickwareERPStockTakeExport.view.pending.List');

        this.callParent(arguments);
    },

    getBottomButtons: function () {
        var buttons = this.callParent(arguments);

        // Change the cls of the existing export button
        buttons[1].cls = 'secondary';

        // Add spacing and two new action buttons. These actions are disabled/enabled respectively for the initial state
        // where no stock takes are counted yet (allow nulling all stock takes, forbid persisting counted stock takes).
        this.saveStockTakesButton = Ext.create('Ext.button.Button', {
            disabled: true,
            text: this.getViisonSnippet('button/saveStockTakes/text'),
            cls: 'primary',
            handler: function () {
                this.fireEvent('saveStockTakes', this, false);
            },
            scope: this,
        });
        this.nullStockTakesButton = Ext.create('Ext.button.Button', {
            disabled: false,
            text: this.getViisonSnippet('button/nullStockTakes/text'),
            cls: 'primary',
            handler: function () {
                this.fireEvent('nullStockTakes', this);
            },
            scope: this,
        });
        buttons = buttons.concat([
            this.saveStockTakesButton,
            this.nullStockTakesButton,
        ]);

        return buttons;
    },
});
