// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockTakeExport.view.pending.ProgressWindow', {

    extend: 'Ext.window.Window',
    alias: 'widget.viison_pickware_erp_stock_take_export-pending-progress_window',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_take_export/main',

    width: 360,
    height: 80,

    /**
     * Display no footer button for this window.
     *
     * @boolean
     */
    footerButton: false,

    /**
     * If the modal property is set to true, the user can't change the window focus to another window.
     *
     * @boolean
     */
    modal: true,

    /**
     * The body padding is used in order to have a smooth side clearance.
     *
     * @integer
     */
    bodyPadding: 10,

    alwaysOnTop: true,
    closable: false,
    resizable: false,
    maximizable: false,
    minimizable: false,

    layout: {
        align: 'stretch',
        type: 'vbox',
    },

    /**
     * @inheritDoc
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('button/nullStockTakes/progressBarTitle');
        this.progressBar = Ext.create('Ext.ProgressBar', {
            animate: true,
            margin: '0 0 15',
            border: 1,
            style: 'border-width: 1px !important;',
            cls: 'left-align',
        });
        this.items = [
            this.progressBar,
        ];
        this.callParent(arguments);
    },
});
