// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.model.Report', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int', useNull: false },
        { name: 'reportingDay', type: 'date', useNull: false },
        { name: 'untilDate', type: 'date', useNull: true },
        { name: 'generationStep', type: 'string', useNull: true },
        { name: 'nextGenerationStep', type: 'string', useNull: true },
        { name: 'generated', type: 'boolean', useNull: false },
        { name: 'progress', type: 'float', useNull: true },
        { name: 'comment', type: 'string', useNull: true },
        { name: 'preview', type: 'bool', useNull: false },
        { name: 'method', type: 'string', useNull: false },
        { name: 'warehouseName', type: 'string' },
        { name: 'warehouseCode', type: 'string' },
    ],
    associations: [
        {
            type: 'hasOne',
            model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse',
            associationKey: 'warehouse',
            getterName: 'getWarehouse',
            setterName: 'setWarehouse',
        },
    ],
});
