// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.model.ReportPurchase', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int', useNull: false },
        { name: 'date', type: 'date', useNull: false },
        { name: 'purchasePriceNet', type: 'float', useNull: false },
        { name: 'quantity', type: 'int', useNull: false },
        { name: 'quantityUsedForValuation', type: 'int', useNull: false },
        { name: 'type', type: 'string', useNull: false },
    ],

    isTypeCarryOver: function () {
        return this.get('type') === 'carry-over';
    },

    isTypePurchase: function () {
        return this.get('type') === 'purchase';
    },

    isTypeSurplus: function () {
        return this.get('type') === 'surplus';
    },

});
