// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.model.ReportRow', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int', useNull: false },
        { name: 'stock', type: 'int', useNull: false },
        { name: 'valuationNet', type: 'float', useNull: true },
        { name: 'valuationGross', type: 'float', useNull: true },
        { name: 'taxRate', type: 'float', useNull: false },
        { name: 'averagePurchasePriceNet', type: 'float', useNull: false },
        { name: 'articleDetailName', type: 'string', useNull: false },
        { name: 'articleDetailNumber', type: 'string', useNull: false },
    ],
    associations: [
        {
            type: 'hasMany',
            model: 'Shopware.apps.ViisonPickwareERPStockValuation.model.ReportPurchase',
            associationKey: 'purchases',
            name: 'getPurchases',
            storeConfig: {
                type: 'viison_pickware_erp_stock_valuation--report_purchase-store',
            },
        },
        {
            type: 'hasOne',
            model: 'Shopware.apps.Article.model.Detail',
            associationKey: 'articleDetail',
            getterName: 'getArticleDetail',
            setterName: 'setArticleDetail',
        },
    ],

});
