// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.store.Report', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPStockValuation.model.Report',
    autoLoad: true,
    remoteFilter: true,
    remoteSort: true,
    sorters: [
        { property: 'reportingDay', direction: 'DESC' },
        { property: 'untilDate', direction: 'DESC' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockValuation/getReports'),
        },
        reader: {
            type: 'json',
            root: 'data',
        },
    },

});
