// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.store.ReportMethod', {

    extend: 'Ext.data.Store',
    fields: [
        'method',
        'name',
    ],
    data: [
        {
            method: 'lifo',
            name: ViisonCommonApp.getSnippet('method/lifo', 'backend/viison_pickware_erp_stock_valuation/main'),
        },
        {
            method: 'fifo',
            name: ViisonCommonApp.getSnippet('method/fifo', 'backend/viison_pickware_erp_stock_valuation/main'),
        },
        {
            method: 'average',
            name: ViisonCommonApp.getSnippet('method/average', 'backend/viison_pickware_erp_stock_valuation/main'),
        },
    ],

    getMethodName: function (method) {
        return this.findRecord('method', method).get('name');
    },

});
