// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.store.ReportPurchase', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPStockValuation.model.ReportPurchase',
    alias: 'store.viison_pickware_erp_stock_valuation--report_purchase-store',

    filterByValuedQuantity: function () {
        this.clearFilter(true /* suppress event <=> do not update UI */);
        this.filter([{
            filterFn: function (purchase) {
                return purchase.get('quantityUsedForValuation') > 0;
            },
        }]);
    },

});
