// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.store.ReportRow', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPStockValuation.model.ReportRow',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [
        { property: 'articleDetailNumber', direction: 'ASC' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPStockValuation/getReportRows'),
        },
        reader: {
            type: 'json',
            root: 'data',
        },
    },

    filterByReport: function (report) {
        this.removeAll();
        if (report) {
            this.clearFilter(true /* suppress event <=> do not update UI */);
            this.filter('report.id', report.get('id'));
        }
    },

    filterBySearchQuery: function (query) {
        this.getProxy().extraParams.query = query;
        this.loadPage(1);
    },

    filterByArticlesWithStock: function (excludeArticlesWithoutStock) {
        var extraParams = this.getProxy().extraParams;
        extraParams.excludeArticlesWithoutStock = excludeArticlesWithoutStock;
        this.loadPage(1);
    },

});
