// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.Filter', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_stock_valuation-filter',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'fit',
    style: {
        backgroundColor: '#f0f2f4',
        borderBottom: '1px solid #A4B5C0 !important',
    },
    height: 'auto',
    padding: 15,
    border: false,

    reportMethodStore: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.items = [
            this.createFilterForm(),
        ];

        this.callParent(arguments);
    },

    /**
     * @return Ext.container.Container
     */
    createFilterForm: function () {
        return {
            xtype: 'form',
            border: false,
            layout: 'hbox',
            items: [{
                xtype: 'label',
                text: this.getViisonSnippet('label/filter/warehouse'),
                cls: 'is--viison-common--label',
                margin: '7 10 0 0',
            }, {
                xtype: 'viison_pickware_erp_warehouse_management-warehouse_combo_box',
                name: 'warehouseSelection',
                allowBlank: false,
                hideLabel: true,
                width: 180,
            }, {
                xtype: 'tbspacer',
                width: 15,
            }, {
                xtype: 'label',
                text: this.getViisonSnippet('label/filter/reporting_day'),
                cls: 'is--viison-common--label',
                margin: '7 10 0 0',
            }, {
                xtype: 'datefield',
                name: 'reportingDay',
                value: new Date(new Date().setDate(new Date().getDate() - 1)),
                maxValue: new Date(),
                allowBlank: false,
                width: 140,
                hideLabel: true,
            }, {
                xtype: 'tbspacer',
                width: 15,
            }, {
                xtype: 'button',
                action: 'generatePreview',
                text: this.getViisonSnippet('button/filter/generate_preview'),
                cls: 'primary',
                margin: '1 0 0 0',
                padding: '1 10 1 10',
            }],
        };
    },

    getSelectedValues: function () {
        return {
            reportingDay: this.down('[name="reportingDay"]').getValue(),
            warehouseId: this.down('[name="warehouseSelection"]').getSelectedRecord().get('id'),
        };
    },

});
