// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_stock_valuation-main',
    cls: 'viison_pickware_erp_stock_valuation-main has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'border',
    width: '90%',
    height: '90%',
    maximizable: true,
    minimizable: true,
    border: false,

    reportStore: null,
    reportRowStore: null,
    reportMethodStore: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('title/main');
        this.items = [
            {
                xtype: 'viison_pickware_erp_stock_valuation-filter',
                reportMethodStore: this.reportMethodStore,
                region: 'north',
            },
            {
                xtype: 'viison_pickware_erp_stock_valuation-reports_list',
                store: this.reportStore,
                reportMethodStore: this.reportMethodStore,
                region: 'west',
                split: true,
            },
            {
                xtype: 'viison_pickware_erp_stock_valuation-report',
                itemId: 'reportView',
                reportRowStore: this.reportRowStore,
                reportMethodStore: this.reportMethodStore,
                region: 'center',
            },
        ];

        this.callParent(arguments);
    },

});
