// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.Report', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_stock_valuation-report',
    cls: 'viison_pickware_erp_stock_valuation-report',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'fit',
    border: false,
    style: {
        border: 'none',
        'border-left': '1px solid rgba(164, 181, 192, 1) !important',
    },

    reportRowStore: null,
    reportMethodStore: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.items = [
            {
                xtype: 'container',
                itemId: 'noReportInfo',
                cls: 'is--no-report-info',
                tpl: this.getNoReportInfoTemplate(),
                data: {
                    headline: this.getViisonSnippet('report/info/no_report_selected/headline'),
                    text: this.getViisonSnippet('report/info/no_report_selected/text'),
                },
            },
            {
                xtype: 'container',
                itemId: 'report',
                layout: 'border',
                border: false,
                items: [
                    {
                        xtype: 'viison_pickware_erp_stock_valuation-report-header',
                        itemId: 'reportHeader',
                        reportMethodStore: this.reportMethodStore,
                        region: 'north',
                    },
                    {
                        xtype: 'viison_pickware_erp_stock_valuation-report-products_list',
                        store: this.reportRowStore,
                        region: 'center',
                    },
                    {
                        xtype: 'viison_pickware_erp_stock_valuation-report-total_amounts',
                        itemId: 'totalAmounts',
                        region: 'south',
                    },
                ],
                hidden: true,
            },
        ];

        this.callParent(arguments);
    },

    showReport: function (report) {
        this.down('#noReportInfo').hide();
        this.down('#report').show();
        this.down('#reportHeader').updateReportHeader(report);
        this.down('#totalAmounts').resetTotalAmounts();
    },

    hideReport: function () {
        this.down('#report').hide();
        this.down('#noReportInfo').show();
    },

    /**
     * Updates the data displayed in the price view.
     */
    updateTotalAmounts: function (totalAmountNet, totalAmountGross) {
        this.down('#totalAmounts').update({
            totalNet: ViisonCurrencyFormatter.renderer(totalAmountNet),
            totalGross: ViisonCurrencyFormatter.renderer(totalAmountGross),
        });
    },

    getNoReportInfoTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--text-container">',
                    '<span class="is--icon"></span>',
                    '<span class="is--headline">{headline}</span>',
                    '<span class="is--text">{text}</span>',
                '</div>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
