// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.report.Header', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_stock_valuation-report-header',
    cls: 'viison_pickware_erp_stock_valuation-report-header',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'fit',
    style: {
        borderBottom: '1px solid rgba(164, 181, 192, 0.75) !important',
    },

    reportMethodStore: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.tpl = this.getTemplate();

        this.callParent(arguments);
    },

    afterRender: function () {
        this.callParent();

        this.mon(this.getEl(), 'click', function (event) {
            if (event.getTarget('button[data-action="exportReport"]')) {
                this.fireEvent('exportReport');
            } else if (event.getTarget('button[data-action="savePreview"]')) {
                this.fireEvent('savePreview');
            }
        }, this);
    },

    /**
     * @param {Shopware.apps.ViisonPickwareERPStockValuation.model.Report} report
     */
    updateReportHeader: function (report) {
        this.update({
            isPreview: report.get('preview'),
            warehouseName: report.get('warehouseName'),
            warehouseCode: report.get('warehouseCode'),
            warehouseDeleted: !report.raw.warehouse,
            method: this.reportMethodStore.getMethodName(report.get('method')),
            reportingDay: report.get('reportingDay'),
            comment: report.get('comment') || '',
        });
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--button-container">',
                    '<div class="x-btn primary x-btn-noicon">',
                        '<em>',
                            '<button type="button" class="x-btn-center" hidefocus="true" role="button" autocomplete="off" data-action="exportReport">',
                                '<span class="x-btn-inner">' + this.getViisonSnippet('report/header/button/csv_export') + '</span>',
                            '</button>',
                        '</em>',
                    '</div>',
                    '<tpl if="isPreview">',
                        '<div class="x-btn primary x-btn-noicon">',
                            '<em>',
                                '<button type="button" class="x-btn-center" hidefocus="true" role="button" autocomplete="off" data-action="savePreview">',
                                    '<span class="x-btn-inner">' + this.getViisonSnippet('report/header/button/save_report') + '</span>',
                                '</button>',
                            '</em>',
                        '</div>',
                    '</tpl>',
                '</div>',
                '<div class="is--headline">',
                    '<span>',
                        this.getViisonSnippet('report/header/title'),
                        '<tpl if="isPreview">',
                            ' (' + this.getViisonSnippet('report/header/title/preview') + ')',
                        '</tpl>',
                    '</span>',
                '</div>',
                '<div class="is--columns-container">',
                    '<div class="is--column">',
                        '<div class="is--label">',
                            '<span>' + this.getViisonSnippet('report/header/label/warehouse') + '</span>',
                        '</div>',
                        '<div>',
                            '<tpl if="warehouseName">',
                                '<span>',
                                    '{warehouseName} ({warehouseCode})',
                                    '<tpl if="warehouseDeleted">',
                                        ' <span>(' + this.getViisonSnippet('report/header/warehouse/deleted') + ')</span>',
                                    '</tpl>',
                                '</span>',
                            '<tpl else>',
                                '<span>-</span>',
                            '</tpl>',
                        '</div>',
                    '</div>',
                    '<div class="is--column">',
                        '<div class="is--label">',
                            '<span>' + this.getViisonSnippet('report/header/label/method') + '</span>',
                        '</div>',
                        '<div>',
                            '<tpl if="method">',
                                '<span>{method}</span>',
                            '<tpl else>',
                                '<span>-</span>',
                            '</tpl>',
                        '</div>',
                    '</div>',
                    '<div class="is--column">',
                        '<div class="is--label">',
                            '<span>' + this.getViisonSnippet('report/header/label/reporting_day') + '</span>',
                        '</div>',
                        '<div>',
                            '<tpl if="reportingDay">',
                                '<span>{reportingDay:date("d.m.Y")}</span>',
                            '<tpl else>',
                                '<span>-</span>',
                            '</tpl>',
                        '</div>',
                    '</div>',
                    '<div class="is--column">',
                        '<div class="is--label">',
                            '<span>' + this.getViisonSnippet('report/header/label/comment') + '</span>',
                        '</div>',
                        '<div>',
                            '<tpl if="comment">',
                                '<span>{comment}</span>',
                            '<tpl else>',
                                '<span>-</span>',
                            '</tpl>',
                        '</div>',
                    '</div>',
                '</div>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
