// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.report.ProductsList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_stock_valuation-report-products_list',
    cls: 'viison-common--grid has--vertical-lines has--no-borders has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'fit',
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    createColumns: function () {
        return [
            {
                dataIndex: 'articleDetailNumber',
                header: this.getViisonSnippet('report/products_list/column/ordernumber'),
                flex: 2,
                renderer: function (value, meta, record) {
                    if (!record.raw.articleDetail) {
                        value += ' (' + this.getViisonSnippet('report/products_list/article/deleted') + ')';
                    }

                    return value;
                },
            },
            {
                dataIndex: 'articleDetailName',
                header: this.getViisonSnippet('report/products_list/column/articlename'),
                flex: 4,
            },
            {
                dataIndex: 'stock',
                header: this.getViisonSnippet('report/products_list/column/stock'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'taxRate',
                header: this.getViisonSnippet('report/products_list/column/tax_rate'),
                renderer: function (value) {
                    return value + ' %';
                },
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'valuationNet',
                header: this.getViisonSnippet('report/products_list/column/net'),
                renderer: ViisonCurrencyFormatter.renderer,
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'valuationGross',
                header: this.getViisonSnippet('report/products_list/column/gross'),
                renderer: ViisonCurrencyFormatter.renderer,
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'averagePurchasePriceNet',
                header: this.getViisonSnippet('report/products_list/column/average_purchase_price_net'),
                renderer: ViisonCurrencyFormatter.renderer,
                hidden: true,
                align: 'right',
                flex: 1,
            },
            {
                xtype: 'actioncolumn',
                width: 30,
                align: 'center',
                items: [
                    {
                        iconCls: 'sprite-inbox',
                        tooltip: this.getViisonSnippet('report/products_list/action/open_article'),
                        handler: function (grid, rowIndex, colIndex, item, event, record) {
                            this.fireEvent('showArticleDetail', record);
                        },
                        getClass: function (value, metadata, record) {
                            return !record.raw.articleDetail ? 'is--disabled' : '';
                        },
                        scope: this,
                    },
                ],
            },
        ];
    },

    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'top',
                ui: 'shopware-ui is--viison-common--toolbar',
                items: [
                    {
                        xtype: 'checkboxfield',
                        name: 'excludeArticlesWithoutStock',
                        margin: '2 0 0 0',
                        cls: 'viison-common--checkbox-with-boxlabel',
                        boxLabel: this.getViisonSnippet('report/products_list/checkbox/exclude_articles_without_stock/box_label'),
                    },
                    '->',
                    {
                        xtype: 'textfield',
                        name: 'searchfield',
                        cls: 'searchfield',
                        width: 200,
                        enableKeyEvents: true,
                        emptyText: this.getViisonSnippet('report/products_list/search_field/emptytext'),
                        listeners: {
                            buffer: 500,
                            change: function (field) {
                                this.fireEvent('searchFieldChanged', field.value);
                            },
                            scope: this,
                        },
                    },
                ],
            },
            {
                xtype: 'viison_common_pagination_toolbar-toolbar',
                store: this.store,
            },
            {
                xtype: 'viison_pickware_erp_stock_valuation-report-purchases_list',
                dock: 'right',
            },
        ];
    },

});
