// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.report.PurchasesList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_stock_valuation-report-purchases_list',
    cls: 'viison_pickware_erp_stock_valuation-report-purchases_list viison-common--grid has--vertical-lines viison-common--sidebar has--header-size-large',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'fit',
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },
    collapsed: true,
    collapsible: true,
    collapseDirection: 'right',
    style: {
        border: 'none',
        'border-left': '1px solid #a4b5c0 !important',
    },
    width: 380,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('report/purchases_list/title');
        this.emptyText = this.getViisonSnippet('report/purchases_list/empty_text');
        this.columns = this.getColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    getColumns: function (report) {
        var quantityUsedForValuationColumn = null;
        if (!report || report.get('method') !== 'average') {
            quantityUsedForValuationColumn = {
                dataIndex: 'quantityUsedForValuation',
                header: this.getViisonSnippet('report/purchases_list/column/quantity_used_for_valuation'),
                align: 'right',
                flex: 1,
            };
        }

        return [
            {
                width: 30,
                tdCls: 'is--icon-column',
                align: 'center',
                renderer: function (value, metaData, record) {
                    var tooltip = null;
                    var iconCls = null;

                    if (record.isTypeCarryOver()) {
                        tooltip = this.getViisonSnippet('report/purchases_list/column/type/carry_over');
                        iconCls = 'is--icon-carry-over';
                    } else if (record.isTypePurchase()) {
                        tooltip = this.getViisonSnippet('report/purchases_list/column/type/purchase');
                        iconCls = 'is--icon-purchase';
                    } else if (record.isTypeSurplus()) {
                        tooltip = this.getViisonSnippet('report/purchases_list/column/type/surplus');
                        iconCls = 'is--icon-surplus';
                    }

                    if (iconCls) {
                        return '<img src="'
                        + Ext.BLANK_IMAGE_URL + '" class="x-action-col-icon is--icon-container '
                        + iconCls + '" data-qtip="' + tooltip + '" />';
                    }

                    return '';
                },
            },
            {
                xtype: 'datecolumn',
                dataIndex: 'date',
                header: this.getViisonSnippet('report/purchases_list/column/date'),
                format: 'd.m.Y H:i:s',
                width: 120,
            }, {
                dataIndex: 'quantity',
                header: this.getViisonSnippet('report/purchases_list/column/quantity'),
                align: 'right',
                flex: 1,
            }, quantityUsedForValuationColumn, {
                dataIndex: 'purchasePriceNet',
                header: this.getViisonSnippet('report/purchases_list/column/purchase_price_net'),
                renderer: ViisonCurrencyFormatter.renderer,
                align: 'right',
                width: 90,
            },
        ];
    },

    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'top',
                ui: 'shopware-ui is--viison-common--toolbar',
                items: [
                    {
                        xtype: 'checkboxfield',
                        name: 'showAllPurchases',
                        margin: '2 0 0 0',
                        cls: 'viison-common--checkbox-with-boxlabel',
                        boxLabel: this.getViisonSnippet('report/products_list/checkbox/show_all_purchases/box_label'),
                    },
                ],
            },
        ];
    },

});
