// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.report.TotalAmounts', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_stock_valuation-report-total_amounts',
    cls: 'viison_pickware_erp_stock_valuation-report-total_amounts',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    layout: 'fit',

    /**
     * @Override
     */
    initComponent: function () {
        this.tpl = this.getTemplate();

        this.callParent(arguments);
    },

    resetTotalAmounts: function () {
        this.update({});
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--totals-view">',
                    '<div class="is--price-container">',
                        '<label>',
                            this.getViisonSnippet('report/total_amounts/label/gross') + ':',
                        '</label>',
                        '<span>',
                            '<tpl if="totalGross">',
                                '{totalGross}',
                            '<tpl else>',
                                '-',
                            '</tpl>',
                        '</span>',
                    '</div>',
                    '<div class="is--price-container">',
                        '<label>',
                            this.getViisonSnippet('report/total_amounts/label/net') + ':',
                        '</label>',
                        '<span>',
                            '<tpl if="totalGross">',
                                '{totalNet}',
                            '<tpl else>',
                                '-',
                            '</tpl>',
                        '</span>',
                    '</div>',
                '</div>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
