// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPStockValuation.view.ReportsList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_stock_valuation-reports_list',
    cls: 'viison-common--grid has--vertical-lines viison-common--sidebar has--header-size-large',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_stock_valuation/main',

    border: false,
    style: {
        border: 'none',
        'border-right': '1px solid rgba(164, 181, 192, 1) !important',
    },
    collapsed: false,
    collapsible: true,
    collapseDirection: 'left',
    autoScroll: true,
    width: 350,
    layout: 'fit',
    viewConfig: {
        enableTextSelection: true,
    },

    reportMethodStore: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('reports_list/title');
        this.emptyText = this.getViisonSnippet('reports_list/empty_text');
        this.columns = [{
            xtype: 'datecolumn',
            header: this.getViisonSnippet('reports_list/column/reporting_day'),
            dataIndex: 'reportingDay',
            format: 'd.m.Y',
            width: 80,
        }, {
            header: this.getViisonSnippet('reports_list/column/warehouse'),
            dataIndex: 'warehouseCode',
            renderer: function (value, metaData, record) {
                if (!record.raw.warehouse) {
                    metaData.style = 'text-decoration: line-through';
                }

                return record.get('warehouseName') + ' (' + record.get('warehouseCode') + ')';
            },
            flex: 1,
        }, {
            header: this.getViisonSnippet('reports_list/column/method'),
            dataIndex: 'method',
            flex: 1,
            renderer: function (value) {
                return this.reportMethodStore.getMethodName(value);
            },
            hidden: true,
        }, {
            xtype: 'actioncolumn',
            width: 30,
            align: 'center',
            items: [{
                iconCls: 'sprite-minus-circle-frame',
                handler: function (grid, rowIndex, colIndex, item, event, record) {
                    this.fireEvent('deleteReport', record);
                },
                scope: this,
            }],
        }];

        this.dockedItems = [{
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        }];

        this.callParent(arguments);
    },

});
