// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierCommon.model.ArticleDetail', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'articleId', type: 'int' },
        { name: 'name', type: 'string' },
        { name: 'orderNumber', type: 'string' },
        { name: 'manufacturerName', type: 'string' },
        { name: 'manufacturerArticleNumber', type: 'string' },
        { name: 'availableStock', type: 'int' },
        { name: 'onlineAvailableStock', type: 'int' },
        { name: 'onlinePhysicalStock', type: 'int' },
        { name: 'minimumStock', type: 'int' },
        { name: 'targetStock', type: 'int' },
        { name: 'incomingStock', type: 'int' },
        { name: 'reorder', type: 'int' },
        { name: 'suggestedReorderQuantity', type: 'int' },
        { name: 'purchasePrice', type: 'float', useNull: true },
        { name: 'dropShippingArticle', type: 'bool', defaultValue: false },
    ],
    statics: {
        /**
         * Creates a new filter function that can be passed to an Ext.util.Filter
         * for filtering instances of this model.
         *
         * @param string query
         * @return function
         */
        localFilterMethod: function (query) {
            return function (item) {
                return item.get('name').toLowerCase().search(query.toLowerCase()) !== -1
                    || item.get('orderNumber').toLowerCase().search(query.toLowerCase()) !== -1
                    || item.get('manufacturerName').toLowerCase().search(query.toLowerCase()) !== -1
                    || item.get('manufacturerArticleNumber').toLowerCase().search(query.toLowerCase()) !== -1;
            };
        },
    },

});
