// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierCommon.store.ArticleDetail', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPSupplierCommon.model.ArticleDetail',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [
        { property: 'name' },
    ],
    constructor: function () {
        // Use proxies from derived classes if they have an alternative proxy
        if (!this.proxy) {
            this.setProxy({
                type: 'ajax',
                url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPSupplierCommon/getArticleDetailList'),
                reader: {
                    type: 'json',
                    root: 'data',
                    totalProperty: 'total',
                },
            });
        }

        this.callParent(arguments);
    },

});
