// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierCommon.view.WarehouseMultiselectionComboBox', {

    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.viison_pickware_erp_supplier_common-warehouse_multiselection-combo-box',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_common/main',

    multiSelect: true,
    displayField: 'displayName',
    valueField: 'id',

    /**
     * @Override
     */
    initComponent: function () {
        this.callParent();
        this.emptyText = this.getViisonSnippet('warehouse_multiselection_combobox/empty_text');

        this.listeners = {
            scope: this,
            change: function (field, selection) {
                var selectedWarehouseIds = [];

                // If the option "all online available warehouses" (warehouse id 0) was set, fix the
                // selectedWarehouseIds to correct IDs of this group
                Ext.each(selection, function (warehouseId) {
                    if (warehouseId === 0) {
                        Ext.each(field.store.data.items, function (warehouse) {
                            if (warehouse.get('stockAvailableForSale')) {
                                selectedWarehouseIds.push(warehouse.get('id'));
                            }
                        }, this);
                    } else {
                        selectedWarehouseIds.push(warehouseId);
                    }
                }, this);

                // Filter duplicates (warehouse id 0 may added duplicates)
                selectedWarehouseIds = selectedWarehouseIds.filter(function (id, pos, arr) {
                    return (arr.indexOf(id) === pos);
                });

                this.fireEvent('selectedWarehouseIdsChanged', this, selectedWarehouseIds);
            },
        };
    },

});
