// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.model.Supplier', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'name', type: 'string' },
        { name: 'salutation', type: 'string' },
        { name: 'contact', type: 'string' },
        { name: 'email', type: 'string' },
        { name: 'phone', type: 'string' },
        { name: 'fax', type: 'string' },
        { name: 'address', type: 'string' },
        { name: 'comment', type: 'string' },
        { name: 'customerNumber', type: 'string' },
        { name: 'number', type: 'string' },
        { name: 'documentLocalizationSubShopId', type: 'int', useNull: true, defaultValue: null },
        { name: 'deliveryTime', type: 'int', defaultValue: 0 },
        { name: 'currencyId', type: 'int' },
        {
            name: 'currencyName',
            type: 'string',
            convert: function (value, record) {
                if (record.raw.currency) {
                    return record.raw.currency.name;
                }

                return '';
            },
        },
    ],
    statics: {
        /**
         * Creates a new filter function that can be passed to an Ext.util.Filter
         * for filtering instances of this model.
         *
         * @param string query
         * @return function
         */
        localFilterMethod: function (query) {
            return function (item) {
                return item.get('name').toLowerCase().search(query.toLowerCase()) !== -1
                    || item.get('contact').toLowerCase().search(query.toLowerCase()) !== -1
                    || item.get('email').toLowerCase().search(query.toLowerCase()) !== -1;
            };
        },
    },
    associations: [{
        type: 'hasOne',
        model: 'Shopware.apps.Base.model.Currency',
        associationKey: 'currency',
        getterName: 'getCurrency',
        setterName: 'setCurrency',
    }],

});
