// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.model.SupplierFabricator', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'supplierId', type: 'int' },
        { name: 'manufacturerId', type: 'int' },
    ],
    associations: [{
        type: 'hasOne',
        model: 'Shopware.apps.ViisonPickwareERPSupplierManagement.model.Supplier',
        associationKey: 'supplier',
        getterName: 'getSupplier',
        setterName: 'setSupplier',
    }, {
        type: 'hasOne',
        model: 'Shopware.apps.ViisonPickwareERPSupplierManagement.model.Fabricator',
        associationKey: 'manufacturer',
        getterName: 'getManufacturer',
        setterName: 'setManufacturer',
    }],

});
