// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.store.SupplierFabricator', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPSupplierManagement.model.SupplierFabricator',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [
        { property: 'manufacturer.name' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl(
                'ViisonPickwareERPSupplierManagement/getSupplierFabricatorList'
            ),
            create: ViisonCommonApp.assembleBackendUrl(
                'ViisonPickwareERPSupplierManagement/createSupplierFabricators'
            ),
            update: ViisonCommonApp.assembleBackendUrl(
                'ViisonPickwareERPSupplierManagement/updateSupplierFabricators'
            ),
            destroy: ViisonCommonApp.assembleBackendUrl(
                'ViisonPickwareERPSupplierManagement/deleteSupplierFabricators'
            ),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
