// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.view.Edit', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_supplier_management-edit',

    layout: 'fit',
    autoShow: true,
    width: '90%',
    height: '90%',
    border: false,

    /**
     * @Override
     */
    initComponent: function () {
        this.items = [{
            xtype: 'tabpanel',
            border: false,
            cls: 'viison-common--tab-panel',
            items: [{
                xtype: 'viison_pickware_erp_supplier_management-edit-base',
                record: this.record,
                documentLocalizationSubShopStore: this.documentLocalizationSubShopStore,
                currencyStore: this.currencyStore,
            }, {
                xtype: 'viison_pickware_erp_supplier_management-edit-article_assignment',
                record: this.record,
                leftStore: this.leftArticleStore,
                rightStore: this.rightArticleStore,
            }, {
                xtype: 'viison_pickware_erp_supplier_management-edit-fabricator_assignment',
                record: this.record,
                leftStore: this.leftFabricatorStore,
                rightStore: this.rightFabricatorStore,
            }],
        }];

        this.callParent(arguments);
    },

});
