// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.view.edit.ArticleAssignment', {

    extend: 'Shopware.apps.ViisonPickwareERPSupplierCommon.view.AssignmentPanel',
    alias: 'widget.viison_pickware_erp_supplier_management-edit-article_assignment',

    title: ViisonCommonApp.getSnippet(
        'edit/article_assignment/title',
        'backend/viison_pickware_erp_supplier_management/main'
    ),
    leftTitle: ViisonCommonApp.getSnippet(
        'edit/article_assignment/title/left',
        'backend/viison_pickware_erp_supplier_management/main'
    ),
    rightTitle: ViisonCommonApp.getSnippet(
        'edit/article_assignment/title/right',
        'backend/viison_pickware_erp_supplier_management/main'
    ),

    /**
     * @Override
     */
    initComponent: function () {
        this.callParent(arguments);

        // Disable this panel if the article does not exist on the server yet
        this.setDisabled(this.record.phantom);
    },

    /**
     * @Override
     */
    createLeftColumns: function () {
        return this.createArticleColumns();
    },

    /**
     * @Override
     */
    getRightPanelConfig: function () {
        var config = this.callParent(arguments);
        // Allow row editing
        config.plugins = config.plugins || [];
        config.plugins.push(Ext.create('Ext.grid.plugin.RowEditing', {
            clicksToMoveEditor: 1,
            autoCancel: false,
            listeners: {
                edit: function (editor, e) {
                    // Explicitly set the purchase price to fix conversion errors
                    e.record.set('purchasePrice', e.newValues.purchasePrice);
                    e.record.commit();
                    this.fireEvent('articleRowEdited', this, e.record);
                },
                scope: this,
            },
        }));

        // Add pagination
        config.dockedItems = config.dockedItems || [];
        config.dockedItems.splice(0, 0, this.createPagingToolbar(this.rightStore));

        return config;
    },

    /**
     * @Override
     */
    createRightColumns: function () {
        var columns = this.createArticleColumns();
        // Add two more columns for purchase price and order amount
        columns.splice(3, 0, {
            header: ViisonCommonApp.getSnippet(
                'edit/article_assignment/column/supplierArticleNumber',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'supplierArticleNumber',
            flex: 1,
            editor: {
                xtype: 'textfield',
            },
        }, {
            header: ViisonPickwarePurchasePriceHelper.purchasePriceLabel(
                ViisonCommonApp.getSnippet(
                    'edit/article_assignment/column/price',
                    'backend/viison_pickware_erp_supplier_management/main'
                )
            ),
            dataIndex: 'purchasePrice',
            width: 75,
            align: 'right',
            editor: {
                xtype: 'numberfield',
                allowBlank: true,
                minValue: 0,
                step: 0.01,
            },
            scope: this,
            renderer: function (value) {
                // Use the currency of this.record (supplier), not the record of this grid (article)
                return ViisonCurrencyFormatter.formatWithCurrencyInRecord(value, null, this.record);
            },
        }, {
            header: ViisonCommonApp.getSnippet(
                'edit/article_assignment/column/packing_unit',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'packingUnit',
            width: 125,
            align: 'right',
            editor: {
                xtype: 'numberfield',
                allowBlank: false,
                minValue: 1,
                step: 1,
            },
        }, {
            header: ViisonCommonApp.getSnippet(
                'edit/article_assignment/column/minimum_order_amount',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'minimumOrderAmount',
            width: 125,
            align: 'right',
            editor: {
                xtype: 'numberfield',
                allowBlank: true,
                minValue: 0,
                step: 1,
            },
        });

        return columns;
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createArticleColumns: function () {
        return [{
            header: ViisonCommonApp.getSnippet(
                'edit/article_assignment/column/name',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'name',
            flex: 1,
        }, {
            header: ViisonCommonApp.getSnippet(
                'edit/article_assignment/column/order_number',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'orderNumber',
            width: 100,
        }, {
            header: ViisonCommonApp.getSnippet(
                'edit/article_assignment/column/fabricator_name',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'manufacturerName',
            width: 100,
        }, {
            xtype: 'actioncolumn',
            hideable: false,
            align: 'center',
            width: 35,
            items: [{
                iconCls: 'sprite-sticky-notes-pin',
                action: 'showArticleDetail',
                tooltip: ViisonCommonApp.getSnippet(
                    'edit/article_assignment/tooltip/show_article_details',
                    'backend/viison_pickware_erp_supplier_management/main'
                ),
                handler: function (grid, rowIndex) {
                    this.fireEvent('showArticleDetail', grid.getStore().getAt(rowIndex));
                },
                scope: this,
            }],
        }];
    },

});
