// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.view.edit.Base', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_supplier_management-edit-base',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_management/main',

    autoScroll: true,
    bodyStyle: 'border:none;',
    layout: {
        type: 'hbox',
        align: 'stretch',
    },
    documentLocalizationSubShopStore: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('edit/base/title');
        this.items = [
            this.createMasterDataGroup(),
            this.createAddressGroup(),
            this.createCommentGroup(),
        ];

        // Add the cancel and save buttons
        this.dockedItems = [{
            xtype: 'toolbar',
            dock: 'bottom',
            ui: 'shopware-ui is--viison-common--button-panel',
            items: [
                '->',
                {
                    text: this.getViisonSnippet('edit/base/toolbar/button/cancel'),
                    cls: 'secondary',
                    action: 'cancel',
                }, {
                    text: this.getViisonSnippet('edit/base/toolbar/button/save'),
                    cls: 'primary',
                    action: 'save',
                },
            ],
        }];

        this.callParent(arguments);

        // Load the documentLocalizationSubShopStore and set the null/default record manually since it is not handled
        // by this.loadRecord()
        this.documentLocalizationSubShopStore.load({
            scope: this,
            callback: function () {
                if (this.record.get('documentLocalizationSubShopId') === 0 || this.record.get('documentLocalizationSubShopId') === null) {
                    this.getForm().findField('documentLocalizationSubShopId').setValue(
                        this.documentLocalizationSubShopStore.getAt(0).get('displayName')
                    );
                }
            },
        });

        // Fill form with record data
        this.loadRecord(this.record);
    },

    /**
     * @return Ext.form.FieldSet The fieldset containing a all fields for editing the supplier master data.
     */
    createMasterDataGroup: function () {
        return Ext.create('Ext.form.FieldSet', {
            title: this.getViisonSnippet('edit/base/fieldset/master_data/title'),
            cls: 'is--viison-common--fieldset',
            flex: 5,
            margins: '0 5 0 5',
            defaults: {
                labelAlign: 'left',
                labelWidth: 125,
                anchor: '100%',
            },
            items: [{
                xtype: 'textfield',
                name: 'name',
                fieldLabel: this.getViisonSnippet('supplier/field/name'),
                allowBlank: false,
            }, {
                xtype: 'textfield',
                name: 'number',
                fieldLabel: this.getViisonSnippet('supplier/field/number'),
                listeners: {
                    scope: this,
                    render: function (field) {
                        Ext.create('Ext.tip.ToolTip', {
                            html: this.getViisonSnippet('edit/base/tooltip/number'),
                            target: field.getEl(),
                            renderTo: Ext.getBody(),
                        });
                    },
                },
            }, {
                xtype: 'textfield',
                name: 'customerNumber',
                fieldLabel: this.getViisonSnippet('supplier/field/customer_number'),
                listeners: {
                    scope: this,
                    render: function (field) {
                        Ext.create('Ext.tip.ToolTip', {
                            html: this.getViisonSnippet('edit/base/tooltip/customer_number'),
                            target: field.getEl(),
                            renderTo: Ext.getBody(),
                        });
                    },
                },
            }, {
                xtype: 'combo',
                name: 'salutation',
                fieldLabel: this.getViisonSnippet('supplier/field/salutation'),
                allowBlank: true,
                store: Ext.create('Shopware.apps.ViisonPickwareERPSupplierCommon.store.Salutation', {}),
                valueField: 'name',
                displayField: 'title',
                queryMode: 'local',
                editable: false,
            }, {
                xtype: 'textfield',
                name: 'contact',
                fieldLabel: this.getViisonSnippet('supplier/field/contact'),
            }, {
                xtype: 'textfield',
                name: 'email',
                fieldLabel: this.getViisonSnippet('supplier/field/email'),
                vtype: 'email',
            }, {
                xtype: 'textfield',
                name: 'phone',
                fieldLabel: this.getViisonSnippet('supplier/field/phone'),
            }, {
                xtype: 'textfield',
                name: 'fax',
                fieldLabel: this.getViisonSnippet('supplier/field/fax'),
            }, {
                xtype: 'combo',
                name: 'documentLocalizationSubShopId',
                fieldLabel: this.getViisonSnippet('supplier/field/languageAndTemplate'),
                helpText: this.getViisonSnippet('supplier/field/languageAndTemplate/helpText'),
                allowBlank: false,
                store: this.documentLocalizationSubShopStore,
                valueField: 'id',
                displayField: 'displayName',
                editable: false,
            }, {
                xtype: 'numberfield',
                name: 'deliveryTime',
                fieldLabel: this.getViisonSnippet('supplier/field/deliveryTime'),
                minValue: 0,
            }, {
                xtype: 'combo',
                name: 'currencyId',
                fieldLabel: this.getViisonSnippet('supplier/field/currency/label'),
                helpText: this.getViisonSnippet('supplier/field/currency/helpText'),
                allowBlank: false,
                store: this.currencyStore,
                valueField: 'id',
                displayField: 'name',
                editable: false,
            }],
        });
    },

    /**
     * @return Ext.form.FieldSet The fieldset containing a single text area for editing the address.
     */
    createAddressGroup: function () {
        return Ext.create('Ext.form.FieldSet', {
            flex: 3,
            title: this.getViisonSnippet('supplier/field/address'),
            cls: 'is--viison-common--fieldset is--sibling',
            margin: '0 5 0 0',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [{
                xtype: 'textareafield',
                name: 'address',
                height: 214,
            }, {
                xtype: 'box',
                cls: 'is--support-text',
                html: this.getViisonSnippet('edit/base/fieldset/address/info'),
            }],
        });
    },

    /**
     * @return Ext.form.FieldSet The fieldset containing a single text area for editing the comment.
     */
    createCommentGroup: function () {
        return Ext.create('Ext.form.FieldSet', {
            flex: 3,
            title: this.getViisonSnippet('supplier/field/comment'),
            cls: 'is--viison-common--fieldset is--sibling',
            margin: '0 5 0 0',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [{
                xtype: 'textareafield',
                name: 'comment',
                height: 214,
            }, {
                xtype: 'box',
                cls: 'is--support-text',
                html: this.getViisonSnippet('edit/base/fieldset/comment/info'),
            }],
        });
    },

});
