// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.view.edit.FabricatorAssignment', {

    extend: 'Shopware.apps.ViisonPickwareERPSupplierCommon.view.AssignmentPanel',
    alias: 'widget.viison_pickware_erp_supplier_management-edit-fabricator_assignment',

    title: ViisonCommonApp.getSnippet(
        'edit/fabricator_assignment/title',
        'backend/viison_pickware_erp_supplier_management/main'
    ),
    leftTitle: ViisonCommonApp.getSnippet(
        'edit/fabricator_assignment/title/left',
        'backend/viison_pickware_erp_supplier_management/main'
    ),
    rightTitle: ViisonCommonApp.getSnippet(
        'edit/fabricator_assignment/title/right',
        'backend/viison_pickware_erp_supplier_management/main'
    ),

    /**
     * @Override
     */
    initComponent: function () {
        // Add a new toolbar containing single button for assigning all fabricator articles to the supplier
        this.dockedItems = [{
            xtype: 'toolbar',
            dock: 'bottom',
            ui: 'shopware-ui is--viison-common--button-panel is--secondary',
            items: [
                '->',
                {
                    text: ViisonCommonApp.getSnippet(
                        'edit/fabricator_assignment/toolbar/button/assign_all_fabricator_articles',
                        'backend/viison_pickware_erp_supplier_management/main'
                    ),
                    cls: 'primary',
                    action: 'assignAllFabricatorArticles',
                },
            ],
        }];

        this.callParent(arguments);

        // Disable this panel if the article does not exist on the server yet
        this.setDisabled(this.record.phantom);
    },

    /**
     * @Override
     */
    createLeftColumns: function () {
        return this.createFabricatorColumns();
    },

    /**
     * @Override
     */
    getRightPanelConfig: function () {
        var config = this.callParent(arguments);
        // Add pagination
        config.dockedItems = config.dockedItems || [];
        config.dockedItems.splice(0, 0, this.createPagingToolbar(this.rightStore));

        return config;
    },

    /**
     * @Override
     */
    createRightColumns: function () {
        return this.createFabricatorColumns();
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createFabricatorColumns: function () {
        return [{
            xtype: 'gridcolumn',
            header: ViisonCommonApp.getSnippet(
                'edit/fabricator_assignment/column/fabricator',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'name',
            flex: 1,
        }, {
            xtype: 'gridcolumn',
            header: ViisonCommonApp.getSnippet(
                'edit/fabricator_assignment/column/link',
                'backend/viison_pickware_erp_supplier_management/main'
            ),
            dataIndex: 'link',
            flex: 1,
        }];
    },

});
