// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierManagement.view.main.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_supplier_management-main-list',
    cls: 'viison_pickware_erp_supplier_management-main-list viison-common--grid has--no-borders has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_management/main',

    split: true,
    border: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [{
            xtype: 'gridcolumn',
            header: this.getViisonSnippet('supplier/field/number'),
            dataIndex: 'number',
            flex: 1,
        }, {
            xtype: 'gridcolumn',
            header: this.getViisonSnippet('supplier/field/name'),
            dataIndex: 'name',
            flex: 1,
        }, {
            xtype: 'gridcolumn',
            header: this.getViisonSnippet('supplier/field/contact'),
            dataIndex: 'contact',
            flex: 1,
        }, {
            xtype: 'gridcolumn',
            header: this.getViisonSnippet('supplier/field/email'),
            dataIndex: 'email',
            flex: 1,
        }, {
            xtype: 'gridcolumn',
            header: this.getViisonSnippet('supplier/field/phone'),
            dataIndex: 'phone',
            width: 150,
        }, {
            xtype: 'gridcolumn',
            header: this.getViisonSnippet('supplier/field/currency'),
            dataIndex: 'currencyName',
            hidden: true,
            flex: 1,
        }, {
            xtype: 'actioncolumn',
            hideable: false,
            align: 'center',
            width: 60,
            items: [{
                iconCls: 'sprite-pencil',
                action: 'editSupplier',
                tooltip: this.getViisonSnippet('list/tooltip/edit'),
                handler: function (grid, rowIndex) {
                    this.fireEvent('editSupplier', grid.getStore().getAt(rowIndex));
                },
                scope: this,
            }, {
                iconCls: 'sprite-minus-circle',
                action: 'deleteSupplier',
                tooltip: this.getViisonSnippet('list/tooltip/delete'),
                handler: function (grid, rowIndex) {
                    this.fireEvent('deleteSupplier', grid.getStore().getAt(rowIndex));
                },
                scope: this,
            }],
        }];
    },

    /**
     * Creates a button toolbar located at the top as well as a paging toolbar located at the bottom.
     *
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        // Create a toolbar located at the top, containing a button for creating a new supplier
        var topToolbar = Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            items: [
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('list/toolbar/button/add'),
                    iconCls: 'sprite-plus-circle-frame',
                    action: 'addSupplier',
                },
                '->',
                {
                    xtype: 'textfield',
                    name: 'searchfield',
                    cls: 'searchfield',
                    width: 170,
                    enableKeyEvents: true,
                    emptyText: this.getViisonSnippet('search_field/placeholder'),
                    listeners: {
                        buffer: 500,
                        change: function (field) {
                            this.fireEvent('searchFieldChanged', field.value);
                        },
                        scope: this,
                    },
                },
            ],
        });

        // Create a paging toolbar located at the bottom
        var bottomToolbar = {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        };

        return [
            topToolbar,
            bottomToolbar,
        ];
    },

});
