// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.model.Order', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'statusId', type: 'int', defaultValue: 0 },
        { name: 'paymentStatus', type: 'int', defaultValue: 0 },
        { name: 'comment', type: 'string', useNull: true },
        { name: 'documentComment', type: 'string', useNull: true },
        { name: 'created', type: 'date', useNull: true },
        { name: 'deliveryDate', type: 'date', useNull: true },
        { name: 'paymentDueDate', type: 'date', useNull: true },
        { name: 'total', type: 'float' },
        { name: 'totalInDefaultCurrency', type: 'float' },
        { name: 'supplierId', type: 'int' },
        { name: 'warehouseId', type: 'int' },
        { name: 'currencyId', type: 'int' },
    ],
    associations: [{
        type: 'hasMany',
        model: 'Shopware.apps.ViisonPickwareERPSupplierOrders.model.order.Article',
        associationKey: 'items',
        name: 'items',
        getterName: 'getItems',
        setterName: 'setItems',
    }, {
        type: 'hasMany',
        model: 'Shopware.apps.ViisonPickwareERPSupplierOrders.model.order.Attachment',
        associationKey: 'attachments',
        name: 'attachments',
        storeConfig: {
            sorters: [
                { property: 'date', direction: 'DESC' },
            ],
        },
    }, {
        // Fake hasMany association that contains only one supplier
        type: 'hasMany',
        model: 'Shopware.apps.ViisonPickwareERPSupplierManagement.model.Supplier',
        associationKey: 'supplier',
        name: 'supplier',
    }, {
        // Fake hasMany association that contains only one warehouse
        type: 'hasMany',
        model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse',
        associationKey: 'warehouse',
        name: 'warehouse',
    }, {
        type: 'hasOne',
        model: 'Shopware.apps.Base.model.Currency',
        associationKey: 'currency',
        getterName: 'getCurrency',
        setterName: 'setCurrency',
    }],

    /**
     * @return Shopware.apps.ViisonPickwareERPSupplierManagement.model.Supplier
     */
    getSupplier: function () {
        return (this.supplier().count() === 1) ? this.supplier().getAt(0) : null;
    },

    /**
     * Removes all currently existing suppliers from the store and adds the given
     * supplier instead.
     *
     * @param Shopware.apps.ViisonPickwareERPSupplierManagement.model.Supplier supplier
     */
    setSupplier: function (supplier) {
        this.supplier().removeAll(true);
        if (supplier) {
            this.supplier().add(supplier);
        }
    },

    /**
     * @returns Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse
     */
    getWarehouse: function () {
        return (this.warehouse().count() === 1) ? this.warehouse().getAt(0) : null;
    },

});
