// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.model.order.Article', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'articleDetailId', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'name', type: 'string' },
        { name: 'statusId', type: 'int' },
        { name: 'orderedQuantity', type: 'int' },
        { name: 'deliveredQuantity', type: 'int' },
        { name: 'manufacturerName', type: 'string' },
        { name: 'manufacturerArticleNumber', type: 'string' },
        { name: 'price', type: 'float', useNull: true },
        { name: 'deliveryTime', type: 'int', useNull: true },
        { name: 'supplierArticleNumber', type: 'string', useNull: true },
        {
            name: 'incomingQuantity',
            type: 'int',
            convert: function (value, record) {
                var incomingQuantity = record.get('orderedQuantity') - record.get('deliveredQuantity');

                return incomingQuantity > 0 ? incomingQuantity : 0;
            },
        },
    ],

});
